﻿using System;
using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.MediatR;
using QualityManagement.MediatR.RiskManagement;

namespace QualityManagement.API.Controllers.Risk_Management
{
    /// <summary>
    /// Controller for RiskReview
    /// </summary>
    [Route("api/[controller]")]
    [ApiController]
    [Authorize]
    public class RiskReviewController(IMediator _mediator) : BaseController
    {
        /// <summary>
        /// Create A RiskReview 
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [ClaimCheck("ADD_RISK_REVIEW")]
        public async Task<IActionResult> CraeteRiskReview(AddRiskReviewCommand command)
        {
            var result = await _mediator.Send(command);
            return GenerateResponse(result);

        }

        /// <summary>
        /// Get All RiskRevies by Risk Id
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpGet("{id}")]
        [ClaimCheck("VIEW_RISK_REVIEW")]
        public async Task<IActionResult> GetAllRiskReview(Guid id)
        {
            var result = await _mediator.Send(new GetAllRiskReviewCommand() { RiskId = id });
            return GenerateResponse(result);
        }

        /// <summary>
        /// Upadate Risk review by Id
        /// </summary>
        /// <param name="id"></param>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut("{id}")]
        public async Task<IActionResult> UpdateRiskReview(Guid id, UpdateRiskReviewCommand command)
        {
            command.Id = id;
            var result = await _mediator.Send(command);
            return GenerateResponse(result);
        }
    }
}
